﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using DataAccess;
using Ext.Net;
using Newtonsoft.Json;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.Script.Serialization;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Xml;
using System.Xml.Xsl;
using ext = Ext.Net;

//setup an alias for all direct method calls on this page
[DirectMethodProxyID(IDMode = DirectMethodProxyIDMode.Alias, Alias = "PATQENTRY")]

public partial class pat_quickentry : System.Web.UI.Page
{
    /// <summary>
    /// page init
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Init(object sender, EventArgs e)
    {
        this.Page.LoadComplete += new EventHandler(Page_LoadComplete);
    }


    protected void Page_LoadComplete(object sender, EventArgs e)
    {
       
    }
    

    public string READONLY
    {
        get
        {
            string strValue = "";
            if (Session["QEREADONLY"] != null)
            {
                strValue = Session["QEREADONLY"].ToString();
            }

            return strValue;
        }
        set { Session["QEREADONLY"] = Convert.ToString(value); }
    }

    /// <summary>
    /// after commiting a note mark the screen readonly
    /// </summary>
    public void MarkReadOnly(bool bReadOnly)
    {
        if (bReadOnly)
        {
            READONLY = "1";
        }
        else
        {
            READONLY = "0";
        }

        //encounter date time
        dfEventDate.ReadOnly = bReadOnly;
        tfEventTime.ReadOnly = bReadOnly;

        //encounter save button
        if (bReadOnly)
        {
            btnSaveEncounter.Disable();
        }
        else
        {
            btnSaveEncounter.Enable();
        }

        //instruments
        if(bReadOnly)
        {
            btnFinished.Hide();
        }
        else
        {
            btnFinished.Show();
        }
        
        //note
        //
        //save progress
        if (bReadOnly)
        {
            btnSaveEncounter2.Disable();
            dfAssessmentDate.Disable();
            tfAssessmentTime.Disable();
        }
        else
        {
            btnSaveEncounter2.Enable();
            dfAssessmentDate.Enable();
            tfAssessmentTime.Enable();
        }

        //commit to tiu
        if (bReadOnly)
        {
            btnEventNoteCommit.Disable();
        }
        else
        {
            btnEventNoteCommit.Enable();
        }

        //template cbo
        if (bReadOnly)
        {
            cboEventNoteTemplate.Disable();
        }
        else
        {
            cboEventNoteTemplate.Enable();
        }

        //tiunote text
        if (bReadOnly)
        {
            tfEventNote.ReadOnly = true;
        }
        else
        {
            tfEventNote.ReadOnly = false;
        }

        //if readonly we saved the encounter so reload the list so that it "disappears"
        if (bReadOnly)
        {
            LoadOpenEncounters();
        }

        //note selection
        ucNoteSelection.MarkReadOnly(bReadOnly);
    }
    

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public bool OnBeforeMainTabChange(string strTabID)
    {

        return false;
    }

  
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    /// US:7264 save the medical history 
    /// </summary>
    /// <returns></returns>
    //protected void OnMedHxOK(object sender, DirectEventArgs e)
    public ucTBICDSInstrument.AddInstrumentResponsesResult OnInstrumentOK(string strAssessmentDate, 
                                                                          string strAssessmentTime)
    {
        //load instrument usually sets these, but we do things a little different here in that
        //we dont actually create the event module entries until we save
        //
        //need to set these before we try to save..
        //
        //----i think this is obsolete? ucTBICDSInstrument.TBIInstrumentCPAID
        //  ucTBICDSInstrument.TBIInstrumentPatPWID
        //  ucTBICDSInstrument.TBIInstrumentPWEvtID;
        //  ucTBICDSInstrument.TBIInstrumentReadOnly
        //
        //ucTBICDSInstrument.TBIInstrumentPWEvtModID
        //ucTBICDSInstrument.TBIInstrumentIntakeID      

        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetPatPWEventByIDDS(Master, Master.SelectedPatientID, CDataUtils2.ToLong(PatPWEventID));

        ucTBICDSInstrument.TBIInstrumentPatPWID = CDataUtils2.GetDSStringValue(ds, "PAT_PW_ID");
        ucTBICDSInstrument.TBIInstrumentPWEvtID = PatPWEventID;
        ucTBICDSInstrument.TBIInstrumentReadOnly = false;
       
        ucTBICDSInstrument.TBIInstrumentIntakeID = PatIntakeID;

        //need to make a new one of these if patIntakeID is empty
        //ucTBICDSInstrument.TBIInstrumentPWEvtModID
        //this.MID
        CPWEvent evt = new CPWEvent();
        bool bReloadGrids = false;
        if (String.IsNullOrEmpty(PatIntakeID))
        {
            long lEventMIDID = 0;

            evt.InsertPWEventModule(Master,
                                    Master.SelectedPatientID,
                                    CDataUtils2.ToLong(PatPWEventID),
                                    CDataUtils2.ToLong(MID),
                                    out lEventMIDID);

            //todo handle errors
            ucTBICDSInstrument.TBIInstrumentPWEvtModID = Convert.ToString(lEventMIDID);

            //this is now also the selected one
            PWEventModuleID = ucTBICDSInstrument.TBIInstrumentPWEvtModID;

            bReloadGrids = true;
        }
        else
        {
            //set the intake ID
            ucTBICDSInstrument.TBIInstrumentPWEvtModID = PWEventModuleID;
        }
               

        //AddInstrumentResponses actually saves the instrument
        ucTBICDSInstrument.AddInstrumentResponsesResult result = new ucTBICDSInstrument.AddInstrumentResponsesResult();
        result = ucTBICDSInstrument.AddInstrumentResponses(strAssessmentDate, strAssessmentTime);

        if (bReloadGrids)
        {
            //reload the saved instruments now that we have a new one
            LoadSavedInstruments(CDataUtils2.ToLong(PatPWEventID));
            
            //clear any selected instruments including the one we just saved
            dfAssessmentDate.Hide();
            tfAssessmentTime.Hide();
            btnFinished.Hide();
            aspPnlInstrumentContainer.Update();
            gpInstruments.GetSelectionModel().ClearSelection();
            gpSelInstruments.GetSelectionModel().ClearSelection();
        }

        if (result.saved)
        {
            //Master.ShowSystemFeedback("Instrument Saved.", "Success!");

            Notification.Show(new NotificationConfig
            {
                PinEvent = "none",
                Plain = true,
                Header = false,
                Html = "Instrument saved."
            });
        }
        else
        {
            Master.ShowSystemFeedback(result.message, result.title);
        }
    
        return result;
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 cancel note template select
    /// </summary>
    public void OnTemplateCancel()
    {
        //clear the text and close the popup
        taTemplateText.Text = "";
        wndTemplateText.Close();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 Load note template selected
    /// </summary>
    /// <param name="strTemplateID"></param>
    public void LoadNoteTemplate(string strTemplateID)
    {
        CTemplate template = new CTemplate();

        if (!String.IsNullOrEmpty(strTemplateID) && !strTemplateID.Equals("null"))
        {
            string strParsedTemplate = template.GetParsedTemplateText2(Master,
                                                                       Master.SelectedPatientID,
                                                                       PatPWEventID,
                                                                       Convert.ToInt32(strTemplateID));
            taTemplateText.Text = strParsedTemplate.Replace("\n\n\n\n","\n");

            //tfEventNote.Text += strParsedTemplate;
            cboEventNoteTemplate.SelectedItems.Clear();
            cboEventNoteTemplate.UpdateSelectedItems();
        }

        wndTemplateText.Show();
    }

        
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7303 US:7109 Show confirm
    /// </summary>
    public void OnTIUNoteConfirm()
    {
        //check note title ien
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        if (strSEL_NOTE_TITLE == null)
        {
            strSEL_NOTE_TITLE = "";
        }
        string[] splitNoteTitle = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
        if (splitNoteTitle.Length < 2)//nothing to do
        {
            Master.ShowSystemFeedback("Please select a valid note title!", "Data Entry Error");
            return;

        }

        //check encounter
        string strSEL_NOTE_LOCATION = Convert.ToString(Session["SEL_NOTE_LOCATION"]);
        if (strSEL_NOTE_LOCATION == null)
        {
            strSEL_NOTE_LOCATION = "";
        }
        string[] splitEncounterID = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
        //tfEventNoteLocation.Text.Split(new Char[] { '^' });
        if (splitEncounterID.Length < 2)//nothing to do
        {
            Master.ShowSystemFeedback("Please select a valid note location!", "Data Entry Error");
            return;

        }

        //save the encounter info, don;t show status info
        OnSaveEncounter(false);
        
        //build warning
        taTIUAlert.FieldLabel = "Warning, you are about to commit this note to TIU. Once the note is committed it will be locked and no further changes can be made";

        taTIUAlert.Text = "";
        //taTIUAlert.Text += "\r\n\r\n";

        taTIUAlert.Text += "Note Title: " + splitNoteTitle[0];// +tfEventNoteTitle.Text;
        taTIUAlert.Text += "\r\n\r\n";

        taTIUAlert.Text += "Encounter Location: " + splitEncounterID[0];// tfEventNoteLocation.Text;
        taTIUAlert.Text += "\r\n\r\n";
        
        string strConsult = Convert.ToString(Session["SEL_NOTE_CONSULT"]);
        if (strConsult == null)
        {
            strConsult = "";
        }
        else
        {
            string[] splitConsult = strConsult.Split(new Char[] { '^' });
            if (splitConsult.Length > 1)
            {
                taTIUAlert.Text += "Consult: " + strConsult[0];
                taTIUAlert.Text += "\r\n\r\n";
            }
        }

        string strCosigner = Convert.ToString(Session["SEL_NOTE_COSIGN"]);
        if (strCosigner == null)
        {
            strCosigner = "";
        }
        else
        {
            string[] splitCosigner = strCosigner.Split(new Char[] { '^' });
            if (splitCosigner.Length > 1)
            {
                taTIUAlert.Text += "Cosigner: " + splitCosigner[0];
                taTIUAlert.Text += "\r\n\r\n";
            }
        }

        //taTIUAlert.Text += "Note: " + tfEventNote.Text;
        //taTIUAlert.Text += "\r\n\r\n";
        
        taTIUAlert.Text += "\r\n";
        winTIUWarning.Show();
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "UpdateEncHash")]
    /// <summary>
    ///US:7303 US:7109 commit the note to tiu
    /// </summary>
    public object CommitEventNote()
    {
        Session["PING_MDWS"] = "1";

        X.Mask.Hide();

        //get note title ien
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        string strNoteTitleIEN = "";
        string[] splitNoteTitle = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
        if (splitNoteTitle.Length < 2)//nothing to do
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("Please select a valid note title!", "Data Entry Error");
            return new { submitted = false };

        }
        strNoteTitleIEN = splitNoteTitle[1];

        //get encounter
        string strEncounterID = "";
        string strSEL_NOTE_LOCATION = Convert.ToString(Session["SEL_NOTE_LOCATION"]);
        string[] splitEncounterID = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
        if (splitEncounterID.Length < 2)//nothing to do
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("Please select a valid note location!", "Data Entry Error");
            return new { submitted = false };

        }
        strEncounterID = splitEncounterID[1];

        //get consult ien 
        string strSEL_NOTE_CONSULT = Convert.ToString(Session["SEL_NOTE_CONSULT"]);
        string strConsultIEN = "";
        string[] splitConsult = strSEL_NOTE_CONSULT.Split(new Char[] { '^' });
        if (splitConsult.Length > 1)
        {
            strConsultIEN = splitConsult[1];
        }

        //get cosigner duz 
        string strSEL_NOTE_COSIGN = Convert.ToString(Session["SEL_NOTE_COSIGN"]);
        string strCosignerDUZ = "";
        string[] splitCosign = strSEL_NOTE_COSIGN.Split(new Char[] { '^' });
        if (splitCosign.Length > 1)
        {
            strCosignerDUZ = splitCosign[1];
        }

        //get the clinic id
        long lClinicID = -1;
        string[] splitEncID = strEncounterID.Split(new Char[] { ';' });
        if (splitEncID.Length > 1)//valid string
        {
            lClinicID = CDataUtils2.ToLong(splitEncID[0]);
        }

        //write the note and return 
        string strTIUNoteID = "";
        string strTIUNote = "";
        CMDWSOps ops = new CMDWSOps(Master.GetDataObject());
        
        //select the patient in MDWS so that its the currently selected patient
        //this is just to make 100% sure the patient is selected
        string strPatID = "";
        CStatus stat = ops.TransferPatientByDFN(Master.Key,
                                                Master.DFN,
                                                out strPatID);

        //format the note
        string strNote = HttpUtility.HtmlDecode(tfEventNote.Text);
        strNote = strNote.Replace("\n", "\r\n");

        //write the note to MDWS
        CStatus status = ops.WriteNote2(Master.DFN,
                                         Master.DUZ,
                                         strNoteTitleIEN,
                                         strEncounterID,
                                         strNote,
                                         strConsultIEN,
                                         strCosignerDUZ,
                                         out strTIUNoteID,
                                         out strTIUNote);

        if (!status.Status)
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback(status.StatusComment, "Error writing note to TIU");
            return new { submitted = false };
        }

        //sometimes we error out for no reason this catches it....
        if (String.IsNullOrEmpty(strTIUNote) || CDataUtils2.ToLong(strTIUNoteID) < 1)
        {
            Session["PING_MDWS"] = null;

            string strErr = "An error occurred while writing the note, ";
            strErr += "if this error continues please contact your system administrator.";

            Master.ShowSystemFeedback(strErr, "Error writing note to TIU");
            return new { submitted = false };
        }
        

        // the note is successfully written to tiu so update the TBI data
        CPWEvent evt = new CPWEvent();
        bool bStatus = evt.WriteNote(Master,
                                     CDataUtils2.ToLong(PatPWEventID),
                                     Master.DFN,
                                     Master.DUZ,
                                     strEncounterID,
                                     strConsultIEN,
                                     strCosignerDUZ,
                                     strNoteTitleIEN,
                                     strTIUNoteID,
                                     strTIUNote,
                                     lClinicID,
                                     1,//todo and consult...
                                     strSEL_NOTE_TITLE,//tfEventNoteTitle.Text,
                                     strSEL_NOTE_LOCATION,//tfEventNoteLocation.Text,
                                     strSEL_NOTE_COSIGN,//tfEvtNoteCosigner.Text,
                                     strSEL_NOTE_CONSULT,//tfEvtNoteConsult.Text,
                                     HttpUtility.HtmlDecode(tfEventNote.Text));

        if (!bStatus)
        {
            Session["PING_MDWS"] = null;

            Master.ShowSystemFeedback("The note was written to TIU, but failed to save to TBI CDS", "Error writing note to TIU");
            return new { submitted = false };
        }

        //lock it
        tfEventNote.ReadOnly = true;
        cboEventNoteTemplate.Disable();
        tfEventNote.Text = strTIUNote;
        winTIUWarning.Close();
        Notification.Show(new NotificationConfig
        {
            PinEvent = "none",
            Plain = true,
            Header = false,
            Html = "The note was successfully written to TIU!"
        });

        Session["PING_MDWS"] = null;

        MarkReadOnly(true);
        
        //update the prev hash
        //hidPrevEncHash.Text = ucNoteSelection.GetEncounterHash() + tfEventNote.Text;

        //reset the instruments user control
        ucTBICDSInstrument.m_lInstrumentID = 1;
        ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());

        dfAssessmentDate.Hide();
        tfAssessmentTime.Hide();
        btnFinished.Hide();
        aspPnlInstrumentContainer.Update();
        gpInstruments.GetSelectionModel().ClearSelection();
        gpSelInstruments.GetSelectionModel().ClearSelection();

        
        return new { submitted = true };
    }

    // <summary>
    /// US:7112 Selected patient pathway event id
    /// </summary>
    public string PatPWEventID
    {
        get
        {
            string strValue = "";
            if (Session["QEPatPWEventID"] != null)
            {
                strValue = Session["QEPatPWEventID"].ToString();
            }

            return strValue;
        }
        set { Session["QEPatPWEventID"] = Convert.ToString(value); }
    }

    public string PatIntakeID
    {
        get
        {
            string strValue = "";
            if (Session["QEPatIntakeID"] != null)
            {
                strValue = Session["QEPatIntakeID"].ToString();
            }

            return strValue;
        }
        set { Session["QEPatIntakeID"] = Convert.ToString(value); }
    }

    public string PWEventModuleID
    {
        get
        {
            string strValue = "";
            if (Session["QEPWEventModuleID"] != null)
            {
                strValue = Session["QEPWEventModuleID"].ToString();
            }

            return strValue;
        }
        set { Session["QEPWEventModuleID"] = Convert.ToString(value); }
    }

    public string MID
    {
        get
        {
            string strValue = "";
            if (Session["QEMID"] != null)
            {
                strValue = Session["QEMID"].ToString();
            }

            return strValue;
        }
        set { Session["QEMID"] = Convert.ToString(value); }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "UpdateEncHash")]
    /// <summary>
    ///clear the view for a new encounter
    /// </summary>
    public void OnSaveEncounter(bool bShowSuccess)
    {
        //get the encounter date
        DateTime dtEncounter = new DateTime(dfEventDate.SelectedDate.Year,
                                            dfEventDate.SelectedDate.Month,
                                            dfEventDate.SelectedDate.Day,
                                            tfEventTime.SelectedTime.Hours,
                                            tfEventTime.SelectedTime.Minutes,
                                            tfEventTime.SelectedTime.Seconds);
        //cpa 
        CCPA cpa = new CCPA();
        CPWEvent evt = new CPWEvent();
          
        
        if (!String.IsNullOrEmpty(PatPWEventID))
        {
            //update event info 
            bool bStatus = cpa.UpdatePWEvent(Master,
                                             Master.SelectedPatientID,
                                             CDataUtils2.ToLong(PatPWEventID),
                                             "",
                                             dtEncounter,
                                             0);

            if (!bStatus)
            {
                Master.ShowSystemFeedback("Error updating the event, please contact your system administrator!", "Error");
                return;
            }
        }
        else
        {
            //insert new event
            //
            //get the 'No Pathway'
            DataSet ds = evt.GetNoPathwayDS(Master);
            if (!CDataUtils2.IsEmpty(ds))
            {
                //get the pathway id
                long lPatPWID = CDataUtils2.GetDSLongValue(ds, "PAT_PW_ID");
                long lPatPWEventID = 0;

                //does not have an event for today in the 'no pathway' so add one
                bool bStatus = evt.InsertPWEvent(Master,
                                                 Master.SelectedPatientID,
                                                 lPatPWID,
                                                 Master.RegionID,
                                                 Master.SiteID,
                                                 "",
                                                 dtEncounter,
                                                 out lPatPWEventID);

                if (!bStatus)
                {
                    Master.ShowSystemFeedback("Error inserting the event, please contact your system administrator!", "Error");
                    return;
                }

                //keep the newly inserted patient event id
                PatPWEventID = Convert.ToString(lPatPWEventID);

                //reload the encounter combo
                LoadOpenEncounters();

                //clear any selected instruments
                dfAssessmentDate.Hide();
                tfAssessmentTime.Hide();
                btnFinished.Hide();
                aspPnlInstrumentContainer.Update();
                gpInstruments.GetSelectionModel().ClearSelection();
                gpSelInstruments.GetSelectionModel().ClearSelection();
       
            }
        }

        if (bShowSuccess)
        {
            gpOpenEncs.Hide();
            this.LoadOpenEncounters();
            gpOpenEncs.Show();
            //gpOpenEncs.Update();
        }

        //save note title progress
        string strSEL_NOTE_TITLE = Convert.ToString(Session["SEL_NOTE_TITLE"]);
        string strSEL_NOTE_CONSULT = Convert.ToString(Session["SEL_NOTE_CONSULT"]);
        string strSEL_NOTE_LOCATION = Convert.ToString(Session["SEL_NOTE_LOCATION"]);
        string strSEL_NOTE_COSIGN = Convert.ToString(Session["SEL_NOTE_COSIGN"]);
        bool bStatus2 = evt.SaveNoteProgress(Master,
                                       CDataUtils2.ToLong(PatPWEventID),
                                       1,//todo...
                                       strSEL_NOTE_TITLE,//tfEventNoteTitle.Text,
                                       strSEL_NOTE_LOCATION,//tfEventNoteLocation.Text,
                                       strSEL_NOTE_COSIGN,//tfEvtNoteCosigner.Text,
                                       strSEL_NOTE_CONSULT,//tfEvtNoteConsult.Text,
                                       HttpUtility.HtmlDecode(tfEventNote.Text));
        if (!bStatus2)
        {
            Master.ShowSystemFeedback("Failed to save note progress!", "Error saving note");
            return;
        }

        //set the note title on the note tab
        tfEventNoteTitle.Text = "";
        if (Session["SEL_NOTE_TITLE"] != null)
        {
            string[] splitNoteTitle = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
            if (splitNoteTitle.Length > 1)
            {
                tfEventNoteTitle.Text = splitNoteTitle[0];
            }
        }

        //enable the instruments and note tabs
        //tpMain.Items[1].Enable();
        pnlInstruments.Enable();
        
        tpMain.Items[2].Enable();

        //show success
     //   if (bShowSuccess)
       // {
         //   Master.ShowSystemFeedback("Encounter successfully saved.", "Success");
       // }
        if (bShowSuccess)
        {
            Notification.Show(new NotificationConfig
            {
                PinEvent = "none",
                Plain = true,
                Header = false,
                Html = "Encounter/Note saved."
            });
        }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///clear the view for a new encounter
    /// </summary>
    public void OnNewEncounter()
    {
        MarkReadOnly(false);

        //clear session vars
        Session["SEL_NOTE_TITLE"] = "";
        Session["SEL_NOTE_CONSULT"] = "";
        Session["SEL_NOTE_LOCATION"] = "";
        Session["SEL_NOTE_COSIGN"] = "";

        //reset the event
        PatPWEventID = "";

        //set the date time to now, this was removed after testing 
        //was decided to just use whatever values are selected
        //in the date time controls...
        //
        //dfEventDate.SelectedDate = DateTime.Today;
        //tfEventTime.SelectedTime = new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);

        //initialize the note selection control
        ucNoteSelection.InitializeControl("", "", "", "");

        //reset the full instrument list to all
        rdoQEEITAll.Checked = true;
        OnGroupTypeSelect();

        //clear the isntrument
        ucTBICDSInstrument.InstrumentOptions result = ucTBICDSInstrument.LoadInstrument(Master.SelectedPatientID,
                                                                                         Master.SiteID.ToString(),
                                                                                         1,
                                                                                         0,
                                                                                         0,
                                                                                         false);
        //update the views
        aspPnlInstrumentContainer.Update();
       
        //reset the instruments user control
        ucTBICDSInstrument.m_lInstrumentID = 1;
        ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());
        
        //clear saved instruments
        LoadSavedInstruments(-1);

        //clear the note
        tfEventNote.Text = "";
       
        //clear the selected note templates
        cboEventNoteTemplate.SelectedItems.Clear();
        cboEventNoteTemplate.UpdateSelectedItems();

        //disable tabs until save
        //tpMain.Items[1].Disable();
        //pnlInstruments.Disable();
       
        //tpMain.Items[2].Disable();
        OnSaveEncounter(true);
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7111 US:7110 Load note template select
    /// </summary>
    public void OnTemplateSave()
    {
        //top, bot or replace
        string strTop = rdoTemplTop.Value.ToString();
        string strBot = rdoTemplBottom.Value.ToString();
        string strReplace = rdoTemplReplace.Value.ToString();

        string strTemplateText = taTemplateText.Text;
        
        //top
        if (strTop.ToUpper() == "TRUE")
        {
            tfEventNote.Text = HttpUtility.HtmlDecode(strTemplateText) + "\r\n" + HttpUtility.HtmlDecode(tfEventNote.Text);
        }

        //bot
        if (strBot.ToUpper() == "TRUE")
        {
            tfEventNote.Text += "\r\n" + HttpUtility.HtmlDecode(strTemplateText);
        }

        //replace
        if (strReplace.ToUpper() == "TRUE")
        {
            tfEventNote.Text = HttpUtility.HtmlDecode(strTemplateText);
        }

        //clear the text and close the popup
        taTemplateText.Text = "";
        wndTemplateText.Close();
    }

    public void LoadNote()
    {


    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn="UpdateEncHash")]
    /// <summary>
    ///US:7356 fires when a group is selected from the combo
    /// </summary>
    public void OnEncounterChange(string strJSON)
    {
        MarkReadOnly(false);

        //get the mid from the record
        string strJ = strJSON;
        if (strJ.Length > 2)
        {
            if (strJ.Substring(0, 1) == "[")
            {
                strJ = strJ.Substring(1);
            }

            if (strJ.Substring(strJ.Length - 1, 1) == "]")
            {
                strJ = strJ.Substring(0, strJ.Length - 1);
            }
        }
        string stPWEventID = CDataUtils2.GetJsonRecordValue("PAT_PW_EVENT_ID", strJ);
        long lPWEventID = CDataUtils2.ToLong(stPWEventID);
        if (lPWEventID > 0)
        {
            //keep the PW event id
            PatPWEventID = stPWEventID;
            LoadEncounter(lPWEventID);
        }

        //reset the instruments user control
        ucTBICDSInstrument.m_lInstrumentID = 1;
        ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());
     
        dfAssessmentDate.Hide();
        tfAssessmentTime.Hide();
        btnFinished.Hide();
        aspPnlInstrumentContainer.Update();
        gpInstruments.GetSelectionModel().ClearSelection();
        gpSelInstruments.GetSelectionModel().ClearSelection();

    }

    /// <summary>
    /// reloads the encounter 
    /// </summary>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "UpdateEncHash")]
    public void ReLoadEncounter()
    {
        LoadEncounter(CDataUtils2.ToLong(PatPWEventID));

        //clear any selected instruments 
        dfAssessmentDate.Hide();
        tfAssessmentTime.Hide();
        btnFinished.Hide();
        aspPnlInstrumentContainer.Update();
        gpInstruments.GetSelectionModel().ClearSelection();
        gpSelInstruments.GetSelectionModel().ClearSelection();

    }

    /// <summary>
    /// load all encounter data
    /// </summary>
    /// <param name="lPWEventID"></param>
    public void LoadEncounter(long lPWEventID)
    {
        //get the info for the event selected
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetPatPWEventByIDDS(Master,
                                             Master.SelectedPatientID,
                                             lPWEventID);

        if (!CDataUtils2.IsEmpty(ds))
        {
            long lStatus = CDataUtils2.GetDSLongValue(ds, "STATUS");

            //set the encounter date time
            DateTime dtEncDate = CDataUtils2.GetDSDateTimeValue(ds, "DATE_SCHEDULED");
            dfEventDate.SelectedDate = dtEncDate;
            tfEventTime.SelectedTime = new TimeSpan(dtEncDate.Hour, dtEncDate.Minute, dtEncDate.Second);

            //load the note control
            string strNoteTitle = "";
            string strNoteLocation = "";
            string strNoteConsult = "";
            string strNoteCosigner = "";

            //note title
            string strSEL_NOTE_TITLE = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_NOTE_TITLE"));
            if (strSEL_NOTE_TITLE == null)
            {
                strSEL_NOTE_TITLE = "";
            }
            Session["SEL_NOTE_TITLE"] = strSEL_NOTE_TITLE;
            string[] spltNT = strSEL_NOTE_TITLE.Split(new Char[] { '^' });
            tfEventNoteTitle.Text = "";//HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_NOTE_TITLE"));
            if (spltNT.Length > 0)
            {
                tfEventNoteTitle.Text = spltNT[0];
                strNoteTitle = tfEventNoteTitle.Text; 
            }

            //note location
            string strSEL_NOTE_LOCATION = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_LOCATION"));
            if (strSEL_NOTE_LOCATION == null)
            {
                strSEL_NOTE_LOCATION = "";
            }
            Session["SEL_NOTE_LOCATION"] = strSEL_NOTE_LOCATION;
            string[] spltLoc = strSEL_NOTE_LOCATION.Split(new Char[] { '^' });
            tfEventNoteLocation.Text = ""; //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_LOCATION"));
            if (spltLoc.Length > 0)
            {
                tfEventNoteLocation.Text = spltLoc[0];
                strNoteLocation = tfEventNoteLocation.Text;
            }

            //cosigner
            string strSEL_NOTE_COSIGN = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_COSIGNER"));
            if (strSEL_NOTE_COSIGN == null)
            {
                strSEL_NOTE_COSIGN = "";
            }
            Session["SEL_NOTE_COSIGN"] = strSEL_NOTE_COSIGN;
            string[] spltCosign = strSEL_NOTE_COSIGN.Split(new Char[] { '^' });
            tfEvtNoteCosigner.Text = "";  //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_COSIGNER"));
            if (spltCosign.Length > 0)
            {
                tfEvtNoteCosigner.Text = spltCosign[0];
                strNoteCosigner = tfEvtNoteCosigner.Text;
            }

            //consult
            string strSEL_NOTE_CONSULT = HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_CONSULT"));
            if (strSEL_NOTE_CONSULT == null)
            {
                strSEL_NOTE_CONSULT = "";
            }
            Session["SEL_NOTE_CONSULT"] = strSEL_NOTE_CONSULT;
            string[] spltCons = strSEL_NOTE_CONSULT.Split(new Char[] { '^' });
            tfEvtNoteConsult.Text = strSEL_NOTE_CONSULT;  //HttpUtility.HtmlDecode(CDataUtils2.GetDSStringValue(ds, "TIU_CONSULT"));
            if (spltCons.Length > 0)
            {
                tfEvtNoteConsult.Text = spltCons[0];
                strNoteConsult = tfEvtNoteConsult.Text;
            }

            string strTxt = "";

            //note text, 2 = closed so load tiu note
            if (lStatus != 2)
            {
                strTxt = CDataUtils2.GetDSStringValue(ds, "NOTE_TEXT");
                strTxt = HttpUtility.HtmlDecode(strTxt);

                tfEventNote.Text = strTxt;
                if (tfEventNote.Text == null)
                {
                    tfEventNote.Text = "";
                }
            }
            else
            {
                strTxt = CDataUtils2.GetDSStringValue(ds, "TIU_NOTE");
                strTxt = HttpUtility.HtmlDecode(strTxt);

                tfEventNote.Text = strTxt;
                if (tfEventNote.Text == null)
                {
                    tfEventNote.Text = "";
                }

            }
            
            //load the note options
            ucNoteSelection.InitializeControl(strNoteTitle,
                                              strNoteLocation,
                                              strNoteConsult,
                                              strNoteCosigner);

            //load saved instruments
            LoadSavedInstruments(lPWEventID);

            //tpMain.Items[1].Enable();
            pnlInstruments.Enable();
            
            //rgQEEventInstrumentType.Enable();
            //rdoQEEITCPA.Enable();
            //rdoQEEITDisp.Enable();
            //rdoQEEITAll.Enable();
            
            tpMain.Items[2].Enable();

        }
    }

    /// <summary>
    /// US:7356 load instruments gridpanel by group id
    /// </summary>
    protected void LoadInstruments(string strGroupID)
    {
        //get the modules ds
        CIntake im = new CIntake();
        DataSet dsMID = im.GetModuleGroupMIDDS(Master, CDataUtils2.ToLong(strGroupID));

        //get all modules already added to this event
//        string strEventMIDS = GetEventMIDS();

        if (CDataUtils2.IsEmpty(dsMID))
        {
            return;
        }
        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
  //              string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
    //            if (strEventMIDS.IndexOf(strMIDCheck) > -1)
      //          {
        //            //remove mids that are already part of the event
          //          row.Delete();
            //    }
              //  else
                //{
                    //module data is not encoded in the db...
                    row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                    row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                    row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                //}
            }
        }
        dsMID.AcceptChanges();

        //clear the store
        storInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7356 fires when a group is selected from the combo
    /// </summary>
    public void OnGroupSelect()
    {
        //clear the store
        storInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());
        if (cboEventInstrumentGroup.SelectedItem == null)
        {
            return;
        }

        //get the group id from the combo
        string strGroupID = cboEventInstrumentGroup.SelectedItem.Value;

        //enable search
        //EnableSearch();
        DisableSearch();

        //load the instruments for this group
        LoadInstruments(strGroupID);
    }


    /// <summary>
    /// US: 7356 Disable Search controls
    /// </summary>
    private void DisableSearch()
    {
        tfEITSearch.Clear();
        tfEITSearch.ClearInvalid();
        tfEITSearch.Disabled = true;
        btnAddInstrumentSearch.Disabled = true;
    }

    /// <summary>
    /// US: 7356 Enable Search controls
    /// </summary>
    private void EnableSearch()
    {
        tfEITSearch.Disabled = false;
        btnAddInstrumentSearch.Disabled = false;
    }

    /// <summary>
    ///US:7356 load instrument groups into the combo
    /// </summary>
    /// <param name="lGroupTypeID"></param>
    public void LoadInstrumentGroups(long lGroupTypeID)
    {
        //clear value
        cboEventInstrumentGroup.SetValue(null);

        //clear the store
        storEventModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //get the group types ds
        CIntake im = new CIntake();
        DataSet dsModuleGroup = im.GetModuleGroupDS(Master, lGroupTypeID);
        if (CDataUtils2.IsEmpty(dsModuleGroup))
        {
            return;
        }

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storEventModuleGroups.SetDataFromJson(cdc.GetJsonDSString(dsModuleGroup));
    }


    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7356  load the instrument grid based on the combo group type
    /// </summary>
    /// <param name="strGroupTypeID"></param>
    public void OnGroupTypeSelect()
    {
        //clear the instruments
        gpInstruments.GetStore().RemoveAll();
        storInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        if (rdoQEEITCPA.Checked)
        {
            DisableSearch();
            cboEventInstrumentGroup.Show();
            this.LoadInstrumentGroups(1000);
        }
        else if (rdoQEEITDisp.Checked)
        {
            DisableSearch();
            cboEventInstrumentGroup.Show();
            this.LoadInstrumentGroups(2000);
        }
        else
        {
            if (rdoQEEITAll.Checked == false)
            {
                rdoQEEITAll.Checked = true;
            }

            EnableSearch();
            //this.LoadInstrumentGroups(-1);

            //clear value
            cboEventInstrumentGroup.SetValue(null);
            //clear the store
            storEventModuleGroups.SetDataFromJson(CDataUtils2.GetEmptyJSON());
            cboEventInstrumentGroup.Hide();

            //now just load all the modules
            CCPA cpa = new CCPA();
            DataSet dsMID = cpa.GetAllModuleDS(Master);

            //get all modules already added to this event
//            string strEventMIDS = GetEventMIDS();

            foreach (DataTable table in dsMID.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
  //                  string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
    //                if (strEventMIDS.IndexOf(strMIDCheck) > -1)
      //              {
        //                //remove mids that are already part of the event
          //              row.Delete();
            //        }
              //      else
                //    {
                        //module data is not encoded in the db...
                        row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                        row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                        row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                  //  }
                }
            }
            dsMID.AcceptChanges();

            //clear the store
            storInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            storInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));

        }
    }

    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    /// <summary>
    ///US:7272 US:7356  user searched for instruments
    /// </summary>
    public void OnSearchInstruments()
    {
        string strSearch = tfEITSearch.Text;
        //if (strSearch.Length < 3)
        //{
        //    BaseMstr.ShowSystemFeedback("Search must be at least 3 characters!", "Search Error");
        //    return;
        //}

        DataSet dsMID = null;

        if (rdoQEEITCPA.Checked || rdoQEEITDisp.Checked)
        {
            string strGroupID = cboEventInstrumentGroup.SelectedItem.Value;

            CIntake intake = new CIntake();
            dsMID = intake.GetModuleGroupMIDDS(Master,
                                               Convert.ToInt64(strGroupID),
                                               strSearch);
        }
        else
        {

            CCPA cpa = new CCPA();
            dsMID = cpa.GetModuleSearchDS(Master,
                                          strSearch);
        }

        if (CDataUtils2.IsEmpty(dsMID))
        {
            Master.ShowSystemFeedback("No matches found!", "Search Error");
            return;
        }

        //get all modules already added to this event
      //  string strEventMIDS = GetEventMIDS();

        foreach (DataTable table in dsMID.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
        //        string strMIDCheck = "," + CDataUtils2.GetDSStringValue(row, "MID") + ",";
          //      if (strEventMIDS.IndexOf(strMIDCheck) > -1)
            //    {
              //      //remove mids that are already part of the event
                //    row.Delete();
               // }
                //else
                //{
                    //module data is not encoded in the db...
                    row["MODULE"] = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                    row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                    row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
               // }
            }
        }
        dsMID.AcceptChanges();

        //clear the store
        storInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());

        //load the store from the ds
        CDataConverter cdc = new CDataConverter();
        storInstruments.SetDataFromJson(cdc.GetJsonDSString(dsMID));
    }

    /// <summary>
    /// user selected an instrument from the full list of intruments
    /// </summary>
    /// <param name="strJSON"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "InitQEAssessmentResponses")]
    public ucTBICDSInstrument.InstrumentOptions OnInstrumentSelect(string strJSON)
    {
        dfAssessmentDate.Show();
        tfAssessmentTime.Show();
        btnFinished.Show();

        //new instrument to clear PatIntakeID
        PatIntakeID = "";
        MID = "";
        PWEventModuleID = "";


        //get the mid from the record
        string strJ = strJSON;
        if (strJ.Length > 2)
        {
            if (strJ.Substring(0, 1) == "[")
            {
                strJ = strJ.Substring(1);
            }

            if (strJ.Substring(strJ.Length - 1, 1) == "]")
            {
                strJ = strJ.Substring(0, strJ.Length - 1);
            }
        }
        string strMID = CDataUtils2.GetJsonRecordValue("MID", strJ);
        MID = strMID;

        //reset the instruments user control
        ucTBICDSInstrument.m_lInstrumentID = 1;
        ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());
     
        //load the isntrument
        bool bReadOnly = false;
        if(READONLY == "1")
        {
            bReadOnly = true;
        }
        ucTBICDSInstrument.InstrumentOptions result = ucTBICDSInstrument.LoadInstrument(Master.SelectedPatientID,
                                                                                        Master.SiteID.ToString(),
                                                                                        CDataUtils2.ToLong(strMID),
                                                                                        0,
                                                                                        0,
                                                                                        bReadOnly);
        //set read only
        result.ReadOnly = bReadOnly;

        ucTBICDSInstrument.TBIInstrumentReadOnly = bReadOnly;

        dfAssessmentDate.SelectedDate = DateTime.Today;
        tfAssessmentTime.SelectedTime = new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);

        //update the views
        aspPnlInstrumentContainer.Update();

        return result;
    }

    /// <summary>
    /// user selected and instruments from the saved instrument list qSetQEOptionsObj
    /// </summary>
    /// <param name="strJSON"></param>
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>", SuccessFn = "InitQEAssessmentResponses")]
    public ucTBICDSInstrument.InstrumentOptions OnSelInstrumentSelect(string strJSON)
    {
        dfAssessmentDate.Show();
        tfAssessmentTime.Show();
        btnFinished.Show();

        //strip [ ] from json (just in case)
        string strJ = strJSON;
        if (strJ.Length > 2)
        {
            if (strJ.Substring(0, 1) == "[")
            {
                strJ = strJ.Substring(1);
            }

            if (strJ.Substring(strJ.Length - 1, 1) == "]")
            {
                strJ = strJ.Substring(0, strJ.Length - 1);
            }
        }

        //get mid, intakeid and pw event module id
        string strMID = CDataUtils2.GetJsonRecordValue("MID", strJ);
        string strIntakeID = CDataUtils2.GetJsonRecordValue("INTAKE_ID", strJ);
        string strPWEventModuleID = CDataUtils2.GetJsonRecordValue("PW_EVENT_MODULE_ID", strJ);

        //keep the intake ID etc..
        PatIntakeID = strIntakeID;
        MID = strMID;
        PWEventModuleID = strPWEventModuleID;

        //reset the instruments user control
        ucTBICDSInstrument.m_lInstrumentID = 1;
        ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());

        //set properties based on the selected module
        CCPA cpa = new CCPA();
        DataSet ds = cpa.GetPatPWEventByIDDS(Master, Master.SelectedPatientID, CDataUtils2.ToLong(PatPWEventID));
        ucTBICDSInstrument.TBIInstrumentPatPWID = CDataUtils2.GetDSStringValue(ds, "PAT_PW_ID");
        ucTBICDSInstrument.TBIInstrumentPWEvtID = PatPWEventID;
        ucTBICDSInstrument.TBIInstrumentReadOnly = false;
        ucTBICDSInstrument.TBIInstrumentIntakeID = PatIntakeID;
        ucTBICDSInstrument.TBIInstrumentPWEvtModID = PWEventModuleID;

        //set the assessment date and time
        string strAssessmentDate = CDataUtils2.GetJsonRecordValue("DATE_STARTED", strJ);
        DateTime dtAssessmentDate = System.Runtime.Remoting.Metadata.W3cXsd2001.SoapDateTime.Parse(strAssessmentDate);
        dfAssessmentDate.SelectedDate = dtAssessmentDate;
        tfAssessmentTime.SelectedTime = new TimeSpan(dtAssessmentDate.Hour, dtAssessmentDate.Minute, dtAssessmentDate.Second);

        bool bReadOnly = false;
        if (READONLY == "1")
        {
            bReadOnly = true;
        }

        //load the isntrument
        ucTBICDSInstrument.InstrumentOptions result = ucTBICDSInstrument.LoadInstrument( Master.SelectedPatientID,
                                                                                         Master.SiteID.ToString(),
                                                                                         CDataUtils2.ToLong(strMID),
                                                                                         CDataUtils2.ToLong(strIntakeID),
                                                                                         CDataUtils2.ToLong(strPWEventModuleID),
                                                                                         bReadOnly);

        //set read only
        result.ReadOnly = bReadOnly;

        //update the view
        aspPnlInstrumentContainer.Update();
        
        return result;
    }

    /// <summary>
    /// load saved instruments for the event. 
    /// </summary>
    /// <param name="lPatPWEventID"></param>
    protected void LoadSavedInstruments(long lPatPWEventID)
    {
        //clear the selected instruments
        gpSelInstruments.GetStore().RemoveAll();
        storSelInstruments.SetDataFromJson(CDataUtils2.GetEmptyJSON());
       
        CCPA cpa = new CCPA();
        CIntake intake = new CIntake();
        DataSet dsModules = cpa.GetPatPWEventModuleDS(Master, Master.SelectedPatientID, lPatPWEventID);
        
        //encode records from the dataset 
        foreach (DataTable table in dsModules.Tables)
        {
            foreach (DataRow row in table.Rows)
            {
                string strIntakeID = CDataUtils2.GetDSStringValue(row, "INTAKE_ID");
                long lIntakeID = CDataUtils2.ToLong(strIntakeID);

                //only add instruments completed here
                if (lIntakeID > 0)
                {
                    //module data is not encoded in the db...
                    string strModule = HttpUtility.HtmlEncode(row["MODULE"].ToString());
                    row["MODULE"] = strModule;
                    row["DESCRIPTION"] = HttpUtility.HtmlEncode(row["DESCRIPTION"].ToString());
                    row["MODULE_ALT_LANG"] = HttpUtility.HtmlEncode(row["MODULE_ALT_LANG"].ToString());
                }
                else
                {
                    row.Delete();
                }
            }
        }
        dsModules.AcceptChanges();

        //set the store
        CDataConverter cdc = new CDataConverter();
        string strJsonRecord = cdc.GetJsonDSString(dsModules);
        storSelInstruments.SetDataFromJson(strJsonRecord);
    }

    /// <summary>
    /// load the open encounters combo
    /// </summary>
    public void LoadOpenEncounters()
    {
        CDataConverter cdc = new CDataConverter();

        //load the open encounters combo
        CPWEvent evt = new CPWEvent();
        DataSet dsEnc = evt.GetOpenEncountersDS(Master);
        
        //load the store from the ds
        string strEncJSON = cdc.GetJsonDSString(dsEnc);
        storOpenEncs.SetDataFromJson(strEncJSON);
    }

    /// <summary>
    /// page load
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e)
    {
        //pass base master to the control   
        ucNoteSelection.BaseMstr = Master;
        ucTBICDSInstrument.BaseMstr = Master;

        if (!IsPostBack)
        {
            READONLY = "0";

            PatIntakeID = "";
            MID = "";
            PWEventModuleID = "";
            
            //clear session vars
            Session["SEL_NOTE_TITLE"] = "";
            Session["SEL_NOTE_CONSULT"] = "";
            Session["SEL_NOTE_LOCATION"] = "";
            Session["SEL_NOTE_COSIGN"] = "";

            dfEventDate.SelectedDate = DateTime.Today;
            tfEventTime.SelectedTime = new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);

            dfAssessmentDate.SelectedDate = DateTime.Today;
            tfAssessmentTime.SelectedTime = new TimeSpan(DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);

            //initialize the note selection control
            ucNoteSelection.InitializeControl("","","","");
            
            //load the default encounter, do it here so that if a new encounter is created it will show in the cbo list
            LoadDefaultEncounter();
            
            //load the note templates combo
            CTemplate tmpl = new CTemplate();
            DataSet dsTemplates = tmpl.GetTemplateDS(Master, CTemplate.TemplateTypeID.NOTES);
            //clear the combo
            cboEventNoteTemplate.GetStore().RemoveAll();
            cboEventNoteTemplate.Items.Clear();
            //load the store from the ds
            CDataConverter cdc = new CDataConverter();
            string strTemplatesJSON = cdc.GetJsonDSString(dsTemplates);
            storeEventNoteTemplate.SetDataFromJson(strTemplatesJSON);

            //load the open encounters grid panel
            LoadOpenEncounters();
            
            //default group select
            OnGroupTypeSelect();

            //select the first item in the open encounters grid panel
            //gpOpenEncs.GetSelectionModel().Select(0);
            //gpOpenEncs.GetSelectionModel().UpdateSelection();
            //
            //above was not working so wired up the selection using below on the page 
            //<AfterLayout Handler="if( App.gpOpenEncs.getSelection() == '' )
            //                      {
            //                          App.gpOpenEncs.getSelectionModel().select(0);
            //                      };">
            //</AfterLayout>
            //now this is not working either!    

            //update the prev hash to curr hash
            //hidPrevEncHash.Text = ucNoteSelection.GetEncounterHash() + tfEventNote.Text;
        }


        if (!X.IsAjaxRequest)
        {
            //reset the instruments user control
            ucTBICDSInstrument.m_lInstrumentID = 1;
            ucTBICDSInstrument.InitializeControl(Master.SelectedPatientID, Master.SiteID.ToString());
        }

        if (!IsPostBack)
        {
            dfAssessmentDate.Hide();
            tfAssessmentTime.Hide();
            btnFinished.Hide();
        }
     }

   
    [DirectMethod(ShowMask = true, Msg = "<span role='alert'>Please wait.</span>")]
    public string GetPatPWEventID()
    {
        return PatPWEventID;
    }

    /// <summary>
    /// loads the deafult encounter when coming to the screen the firstr time
    /// </summary>
    public void LoadDefaultEncounter()
    {
        //get todays date
        DateTime dtNow = DateTime.Now;
        
        //get the 'No Pathway'
        CPWEvent evt = new CPWEvent();
        DataSet ds = evt.GetNoPathwayDS(Master);

        if (!CDataUtils2.IsEmpty(ds))
        {
            long lPatPWID = CDataUtils2.GetDSLongValue(ds, "PAT_PW_ID");

            //do we have an event for todays date?
            CPWEvent pwevent = new CPWEvent();
            DataSet dsEvents = pwevent.GetTodaysPatPWEventDS(Master, Master.SelectedPatientID, lPatPWID);
            foreach (DataTable table in dsEvents.Tables)
            {
                foreach (DataRow row in table.Rows)
                {
                    long lStatus = CDataUtils2.GetDSLongValue(row, "STATUS");
                    if (lStatus == 0) //open event
                    {
                        DateTime dtEncDate = CDataUtils2.GetDSDateTimeValue(row, "DATE_SCHEDULED");
                        if (dtEncDate.Month == dtNow.Month)
                        {
                            if (dtEncDate.Day == dtNow.Day)
                            {
                                if (dtEncDate.Year == dtNow.Year)
                                {
                                    //has an open 'no pathway' event for today
                                    long lPatPWEventID = CDataUtils2.GetDSLongValue(row, "PAT_PW_EVENT_ID");

                                    //keep the event id
                                    PatPWEventID = Convert.ToString(lPatPWEventID);
                                    
                                    //load the encounter
                                    LoadEncounter(lPatPWEventID);

                                    return;
                                }
                            }
                        }
                    }
                }
            }

            //does not have an event for today in the 'no pathway' so add one
            CCPA cpa = new CCPA();
            bool bStatus = cpa.InsertPWEvent(Master,
                                             Master.SelectedPatientID,
                                             lPatPWID,
                                             Master.RegionID,
                                             Master.SiteID,
                                             "",
                                             dtNow,
                                             0);

            if (!bStatus)
            {
                Master.ShowSystemFeedback("Error inserting the event, please contact your system administrator!", "Error");
                return;
            }

            //call load default encounter again
            LoadDefaultEncounter();

        }//has a 'no pathway'
    }
}